/*  Prüfung, ob eine Terminerung für einen gegebenen AG möglich ist.
    Gibt bei Terminierbarkeit "true" ansonsten "false" zurück und wirft eine Notice mit dem Grund für die Nichtterminierbarkeit.
*/
-- TODO AXS: Funktion nach gleichem Prinzip, wie scheduling.abk__is_terminatable und scheduling.abk__is_terminatable__info umbauen. -> Ziel: Korrekte Fehlermeldung inkl. betroffene a2_n erhalten.
SELECT tsystem.function__drop_by_regex( 'ab2__is_terminateable', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__is_terminateable(
      _record ab2,
      _loglevel int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
  ) RETURNS bool AS $$
  DECLARE
    _a2w_stukorr numeric;
  BEGIN
        -- Debug
      IF _loglevel >= 4 THEN
          RAISE NOTICE '%', format( 'call: scheduling.ab2__is_terminateable( _record.a2_id => %L, _loglevel => %L )',
                                                                             _record.a2_id      , _loglevel         );
      END IF;

      IF ( _record.a2_ende ) THEN
          IF _loglevel >= 4 THEN
              RAISE NOTICE 'ab2 % marked as done', _record.a2_id;
          END IF;
          RETURN false;
      END IF;

      -- Folgende Prüfung kann entfallen, da AGe mit einer Laufzeit von 0 jetzt auch (mit Startzeit=Endzeit) einterminiert werden.
      /*
      -- auswärts
      IF _record.a2_ausw IS true THEN
          IF coalesce( _record.a2_dlz, 0 ) <= 0 THEN
              IF _loglevel >= 4 THEN
                  RAISE NOTICE 'ab2 % no work, dlz: %', _record.a2_id, _record.a2_dlz;
              END IF;
              RETURN false;
          END IF;
      -- inhaus
      ELSE
          _a2w_stukorr := a2w_stukorr
                          FROM ab2_wkstplan
                         WHERE a2w_a2_id = _record.a2_id
                           AND a2w_marked >= 0;
          -- NOTE AXS: Wegen schlechter Performance auskommtniert: ( scheduling.ab2__required_worktime__get( _record.a2_id ) = 0 )
          IF coalesce( _a2w_stukorr, _record.a2_ta, 0 ) <= coalesce( _record.a2_time_stemp, 0 ) THEN
              IF _loglevel >= 4 THEN
                  RAISE NOTICE 'ab2 %-%, id: % no work, ta: %, stemp: %, required_worktime: %', _record.a2_ab_ix, _record.a2_n, _record.a2_id, coalesce( _a2w_stukorr, _record.a2_ta, 0 ), coalesce( _record.a2_time_stemp, 0 ), scheduling.ab2__required_worktime__get( _record.a2_id );
              END IF;
              RETURN false;
          END IF;
      END IF;
      */

      -- NOTE AXS: Wegen schlechter Perfomanceauskommentiert! Sollte einfach keinen Arbeitsplatz für AG während Terminierung finden.
      IF (
        SELECT
               count(*) FILTER ( WHERE NOT ks_sperr ) = 0
          FROM ksvba
          JOIN ksv ON ks_id = ksb_ks_id
          LEFT JOIN ab2_wkstplan ON a2w_a2_id = _record.a2_id
         WHERE  CASE
                    -- Bevorzugt: Es ist eine Hauptressource über a2w_resource_id_main_fix vorgegeben.
                    WHEN ( a2w_resource_id_main_fix IS NOT null ) THEN
                        ( ksb_id = ( SELECT r.context_id FROM scheduling.resource r WHERE r.context = 'ksvba' AND r.id = a2w_resource_id_main_fix ) )
                    -- Ansosnten: Die möglichen Arbeitsplätze durchgehen.
                    ELSE
                        ( ksb_id = any( scheduling.ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get( _record.a2_id ) ) ) -- TODO AXS nur in abk hinterlegte, nicht aus ASK! Neue Funktion für alle in aktuellen Optionen
                END
      )
      THEN
          IF _loglevel >= 4 THEN
              RAISE NOTICE 'ab2 % with no non ks_sperr workplace ', _record.a2_id;
          END IF;
          RETURN false;
      END IF;

      RETURN true;

  END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;
